'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _httpClient = require('./clients/httpClient');

var _httpClient2 = _interopRequireDefault(_httpClient);

var _configuration = require('./clients/copyFactory/configuration.client');

var _configuration2 = _interopRequireDefault(_configuration);

var _history = require('./clients/copyFactory/history.client');

var _history2 = _interopRequireDefault(_history);

var _trading = require('./clients/copyFactory/trading.client');

var _trading2 = _interopRequireDefault(_trading);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * MetaApi CopyFactory copy trading API SDK
 */
class CopyFactory {

  /**
   * Constructs CopyFactory class instance
   * @param {String} token authorization token
   * @param {Object} opts connection options
   * @param {String} [opts.domain] domain to connect to
   * @param {Number} [opts.requestTimeout] timeout for http requests in seconds
   */
  constructor(token, opts = {}) {
    let domain = opts.domain || 'agiliumtrade.agiliumtrade.ai';
    let requestTimeout = opts.requestTimeout || 60;
    const retryOpts = opts.retryOpts || {};
    let httpClient = new _httpClient2.default(requestTimeout, retryOpts);
    this._configurationClient = new _configuration2.default(httpClient, token, domain);
    this._historyClient = new _history2.default(httpClient, token, domain);
    this._tradingClient = new _trading2.default(httpClient, token, domain);
  }

  /**
   * Returns CopyFactory configuration API
   * @returns {ConfigurationClient} configuration API
   */
  get configurationApi() {
    return this._configurationClient;
  }

  /**
   * Returns CopyFactory history API
   * @return {HistoryClient} history API
   */
  get historyApi() {
    return this._historyClient;
  }

  /**
   * Returns CopyFactory trading API
   * @return {TradingClient} trading API
   */
  get tradingApi() {
    return this._tradingClient;
  }

}
exports.default = CopyFactory;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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