'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _methodAccessError = require('./methodAccessError');

var _methodAccessError2 = _interopRequireDefault(_methodAccessError);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * metaapi.cloud MetaTrader API client
 */
class MetaApiClient {

  /**
   * Constructs MetaTrader API client instance
   * @param {HttpClient} httpClient HTTP client
   * @param {String} token authorization token
   * @param {String} domain domain to connect to, default is agiliumtrade.agiliumtrade.ai
   */
  constructor(httpClient, token, domain = 'agiliumtrade.agiliumtrade.ai') {
    this._httpClient = httpClient;
    this._host = `https://mt-provisioning-api-v1.${domain}`;
    this._token = token;
  }

  /**
   * Returns type of current token
   * @returns {string} Type of current token
   * @protected
   */
  get _tokenType() {
    if (typeof this._token === 'string' && this._token.split('.').length === 3) {
      return 'api';
    }
    if (typeof this._token === 'string' && this._token.split('.').length === 1) {
      return 'account';
    }
    return '';
  }

  /**
   * Checks that current token is not api token
   * @returns {boolean} Indicator of absence api token
   * @protected
   */
  _isNotJwtToken() {
    return typeof this._token !== 'string' || this._token.split('.').length !== 3;
  }

  /**
   * Checks that current token is not account token
   * @returns {boolean} Indicator of absence account token
   * @protected
   */
  _isNotAccountToken() {
    return typeof this._token !== 'string' || this._token.split('.').length !== 1;
  }

  /**
   * Handles no accessing to the method
   * @param {string} methodName Name of method
   * @protected
   * @throws
   */
  _handleNoAccessError(methodName) {
    return _promise2.default.reject(new _methodAccessError2.default(methodName, this._tokenType));
  }

}
exports.default = MetaApiClient;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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