'use strict';

var _is = require('babel-runtime/core-js/object/is');

var _is2 = _interopRequireDefault(_is);

var _should = require('should');

var _should2 = _interopRequireDefault(_should);

var _sinon = require('sinon');

var _sinon2 = _interopRequireDefault(_sinon);

var _streamingMetaApiConnection = require('./streamingMetaApiConnection');

var _streamingMetaApiConnection2 = _interopRequireDefault(_streamingMetaApiConnection);

var _connectionRegistry = require('./connectionRegistry');

var _connectionRegistry2 = _interopRequireDefault(_connectionRegistry);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @test {ConnectionRegistry}
 */
describe('ConnectionRegistry', () => {

  let sandbox;
  let registry;
  let metaApiWebsocketClient = {
    addSynchronizationListener: () => {},
    addReconnectListener: () => {},
    subscribe: () => {}
  };
  let storage = {
    lastHistoryOrderTime: () => new Date('2020-01-01T00:00:00.000Z'),
    lastDealTime: () => new Date('2020-01-02T00:00:00.000Z'),
    loadDataFromDisk: () => ({ deals: [], historyOrders: [] })
  };

  before(() => {
    sandbox = _sinon2.default.createSandbox();
  });

  beforeEach(() => {
    registry = new _connectionRegistry2.default(metaApiWebsocketClient);
    sandbox.stub(_streamingMetaApiConnection2.default.prototype, 'initialize').resolves();
    sandbox.stub(_streamingMetaApiConnection2.default.prototype, 'subscribe').resolves();
  });

  afterEach(() => {
    sandbox.restore();
  });

  /**
   * @test {ConnectionRegistry#connect}
   */
  it('should connect and add connection to registry', async () => {
    let account = { id: 'id' };
    let connection = registry.connect(account, storage);
    await connection.connect();
    (connection instanceof _streamingMetaApiConnection2.default).should.be.true();
    connection.historyStorage.should.equal(storage);
    _sinon2.default.assert.calledOnce(connection.initialize);
    _sinon2.default.assert.calledOnce(connection.subscribe);
    _sinon2.default.assert.match(registry._connections, _sinon2.default.match.has('id', connection));
  });

  /**
   * @test {ConnectionRegistry#connect}
   */
  it('should return the same connection on second connect if same account id', async () => {
    let accounts = [{ id: 'id0' }, { id: 'id1' }];
    let connection0 = registry.connect(accounts[0], storage);
    let connection02 = registry.connect(accounts[0], storage);
    let connection1 = registry.connect(accounts[1], storage);
    await connection0.connect();
    await connection02.connect();
    await connection1.connect();
    _sinon2.default.assert.called(connection0.initialize);
    _sinon2.default.assert.called(connection0.subscribe);
    _sinon2.default.assert.called(connection1.initialize);
    _sinon2.default.assert.called(connection1.subscribe);
    _sinon2.default.assert.match(registry._connections, _sinon2.default.match.has('id0', connection0));
    _sinon2.default.assert.match(registry._connections, _sinon2.default.match.has('id1', connection1));
    _sinon2.default.assert.match((0, _is2.default)(connection0, connection02), true);
    _sinon2.default.assert.match((0, _is2.default)(connection0, connection1), false);
  });

  /**
   * @test {ConnectionRegistry#remove}
   */
  it('should remove the account from registry', async () => {
    let accounts = [{ id: 'id0' }, { id: 'id1' }];
    let connection0 = await registry.connect(accounts[0], storage);
    let connection1 = await registry.connect(accounts[1], storage);
    _sinon2.default.assert.match(registry._connections, _sinon2.default.match.has('id0', connection0));
    _sinon2.default.assert.match(registry._connections, _sinon2.default.match.has('id1', connection1));
    registry.remove(accounts[0].id);
    _sinon2.default.assert.match(registry._connections.id0, undefined);
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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