'use strict';

/**
 * Abstract class which defines history file manager.
 */

module.exports = class FileManager {

  /**
   * Constructs the history storage
   * @param {String} accountId MetaApi account id
   * @param {String} application MetaApi application id
   * @param {HistoryStorage} historyStorage history storage
   */
  constructor(accountId, application, historyStorage) {
    this._accountId = accountId;
    this._application = application;
    this._historyStorage = historyStorage;
    this._startNewDealIndex = -1;
    this._startNewOrderIndex = -1;
  }

  /**
   * Starts a job to periodically save history on disk
   */
  startUpdateJob() {
    if (!this.updateDiskStorageJob) {
      this.updateDiskStorageJob = setInterval(this.updateDiskStorage.bind(this), 60000);
    }
  }

  /**
   * Stops a job to periodically save history on disk
   */
  stopUpdateJob() {
    clearInterval(this.updateDiskStorageJob);
    delete this.updateDiskStorageJob;
  }

  /**
   * Sets the index of the earliest changed historyOrder record
   * @param {number} index index of the earliest changed record 
   */
  setStartNewOrderIndex(index) {
    if (this._startNewOrderIndex > index || this._startNewOrderIndex === -1) {
      this._startNewOrderIndex = index;
    }
  }

  /**
   * Sets the index of the earliest changed deal record
   * @param {number} index index of the earliest changed record 
   */
  setStartNewDealIndex(index) {
    if (this._startNewDealIndex > index || this._startNewDealIndex === -1) {
      this._startNewDealIndex = index;
    }
  }

  /**
   * Retrieves history from saved file
   * @returns {Object} object with deals and historyOrders
   */
  async getHistoryFromDisk() {}

  /**
   * Saves unsaved history items to disk storage
   */
  async updateDiskStorage() {}

  /**
   * Deletes storage files from disk
   */
  async deleteStorageFromDisk() {}

};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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