'use strict';

/**
 * Implements a MetaTrader demo account entity
 */

Object.defineProperty(exports, "__esModule", {
  value: true
});
class MetatraderDemoAccount {

  /**
   * Constructs a MetaTrader demo account entity
   * @param {MetatraderDemoAccountDto} data MetaTrader demo account data
   */
  constructor(data) {
    this._data = data;
  }

  /**
   * Returns account login
   * @return {String} account login
   */
  get login() {
    return this._data.login;
  }

  /**
   * Returns account password
   * @return {String} account password
   */
  get password() {
    return this._data.password;
  }

  /**
   * Returns account serverName
   * @return {String} account serverName
   */
  get serverName() {
    return this._data.serverName;
  }

  /**
   * Returns account investor password
   * @return {String} account investor password
   */
  get investorPassword() {
    return this._data.investorPassword;
  }

}
exports.default = MetatraderDemoAccount;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9tZXRhQXBpL21ldGF0cmFkZXJEZW1vQWNjb3VudC5lczYiXSwibmFtZXMiOlsiTWV0YXRyYWRlckRlbW9BY2NvdW50IiwiY29uc3RydWN0b3IiLCJkYXRhIiwiX2RhdGEiLCJsb2dpbiIsInBhc3N3b3JkIiwic2VydmVyTmFtZSIsImludmVzdG9yUGFzc3dvcmQiXSwibWFwcGluZ3MiOiJBQUFBOztBQUVBOzs7Ozs7O0FBR2UsTUFBTUEscUJBQU4sQ0FBNEI7O0FBRXpDOzs7O0FBSUFDLGNBQVlDLElBQVosRUFBa0I7QUFDaEIsU0FBS0MsS0FBTCxHQUFhRCxJQUFiO0FBQ0Q7O0FBRUQ7Ozs7QUFJQSxNQUFJRSxLQUFKLEdBQVk7QUFDVixXQUFPLEtBQUtELEtBQUwsQ0FBV0MsS0FBbEI7QUFDRDs7QUFFRDs7OztBQUlBLE1BQUlDLFFBQUosR0FBZTtBQUNiLFdBQU8sS0FBS0YsS0FBTCxDQUFXRSxRQUFsQjtBQUNEOztBQUVEOzs7O0FBSUEsTUFBSUMsVUFBSixHQUFpQjtBQUNmLFdBQU8sS0FBS0gsS0FBTCxDQUFXRyxVQUFsQjtBQUNEOztBQUVEOzs7O0FBSUEsTUFBSUMsZ0JBQUosR0FBdUI7QUFDckIsV0FBTyxLQUFLSixLQUFMLENBQVdJLGdCQUFsQjtBQUNEOztBQXhDd0M7a0JBQXRCUCxxQiIsImZpbGUiOiJtZXRhdHJhZGVyRGVtb0FjY291bnQuanMiLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbi8qKlxuICogSW1wbGVtZW50cyBhIE1ldGFUcmFkZXIgZGVtbyBhY2NvdW50IGVudGl0eVxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBNZXRhdHJhZGVyRGVtb0FjY291bnQge1xuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3RzIGEgTWV0YVRyYWRlciBkZW1vIGFjY291bnQgZW50aXR5XG4gICAqIEBwYXJhbSB7TWV0YXRyYWRlckRlbW9BY2NvdW50RHRvfSBkYXRhIE1ldGFUcmFkZXIgZGVtbyBhY2NvdW50IGRhdGFcbiAgICovXG4gIGNvbnN0cnVjdG9yKGRhdGEpIHtcbiAgICB0aGlzLl9kYXRhID0gZGF0YTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGFjY291bnQgbG9naW5cbiAgICogQHJldHVybiB7U3RyaW5nfSBhY2NvdW50IGxvZ2luXG4gICAqL1xuICBnZXQgbG9naW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RhdGEubG9naW47XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhY2NvdW50IHBhc3N3b3JkXG4gICAqIEByZXR1cm4ge1N0cmluZ30gYWNjb3VudCBwYXNzd29yZFxuICAgKi9cbiAgZ2V0IHBhc3N3b3JkKCkge1xuICAgIHJldHVybiB0aGlzLl9kYXRhLnBhc3N3b3JkO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYWNjb3VudCBzZXJ2ZXJOYW1lXG4gICAqIEByZXR1cm4ge1N0cmluZ30gYWNjb3VudCBzZXJ2ZXJOYW1lXG4gICAqL1xuICBnZXQgc2VydmVyTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGF0YS5zZXJ2ZXJOYW1lO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYWNjb3VudCBpbnZlc3RvciBwYXNzd29yZFxuICAgKiBAcmV0dXJuIHtTdHJpbmd9IGFjY291bnQgaW52ZXN0b3IgcGFzc3dvcmRcbiAgICovXG4gIGdldCBpbnZlc3RvclBhc3N3b3JkKCkge1xuICAgIHJldHVybiB0aGlzLl9kYXRhLmludmVzdG9yUGFzc3dvcmQ7XG4gIH1cblxufVxuIl19