'use strict';

var _should = require('should');

var _should2 = _interopRequireDefault(_should);

var _avlTreeReservoir = require('./avlTreeReservoir');

var _avlTreeReservoir2 = _interopRequireDefault(_avlTreeReservoir);

var _sinon = require('sinon');

var _sinon2 = _interopRequireDefault(_sinon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @test {Reservoir}
 */
describe('Reservoir', () => {

  let clock;

  beforeEach(() => {
    clock = _sinon2.default.useFakeTimers();
  });

  afterEach(() => {
    clock.restore();
  });

  /**
   * @test {Reservoir#pushSome}
   */
  it('should be able to accumulate measurements', () => {
    var res = (0, _avlTreeReservoir2.default)(3);
    res.pushSome('test1');
    res.pushSome('test2');
    res.size().should.eql(2);
    res.at(0).data.should.eql('test1');
    res.at(1).data.should.eql('test2');
  });

  /**
   * @test {Reservoir#pushSome}
   */
  it('should randomly remove old elements from Reservoir', () => {
    var res = (0, _avlTreeReservoir2.default)(3);
    res.pushSome(5);
    res.pushSome(4);
    res.pushSome(3);
    res.pushSome(2);
    res.pushSome(1);
    res.size().should.eql(3);
  });

  /**
   * @test {Reservoir#getPercentile}
   */

  it('should calculate percentiles when Reservoir has 5 elements', () => {
    var res = (0, _avlTreeReservoir2.default)(5);
    let data = [5, 1, 3, 2, 4];
    data.forEach(function (e) {
      res.pushSome(e);
    });

    let pers1 = res.getPercentile(75.13);
    let pers2 = res.getPercentile(75.1);
    let pers3 = res.getPercentile(0.05);
    let pers4 = res.getPercentile(50);
    let pers5 = res.getPercentile(75);

    pers1.should.eql(4.0052);
    pers2.should.eql(4.004);
    pers3.should.eql(1.002);
    pers4.should.eql(3);
    pers5.should.eql(4);
  });

  /**
   * @test {Reservoir#removeOldRecords}
   */
  it('should return percentiles for actual records only', () => {
    var res = (0, _avlTreeReservoir2.default)(15, 60000);
    [5, 15, 20, 35, 40, 50].forEach(item => {
      res.pushSome(item);
      clock.tick(10001);
    });
    let pers50 = res.getPercentile(50);
    pers50.should.eql(35);
  });

  it('should run X algorithm', () => {
    var res = (0, _avlTreeReservoir2.default)(15, 60000);
    for (let i = 0; i < 1000; i++) {
      let item = Math.random();
      res.pushSome(item);
      clock.tick(1001);
    }
    _sinon2.default.assert.match(res.size(), 15);
    const max = res.max();
    max.index.should.be.approximately(999, 2);
    max.time.should.be.approximately(999999, 3000);
    clock.tick(60000);
    res.getPercentile(0);
    _sinon2.default.assert.match(res.size(), 0);
  });

  it('should run Z algorithm', () => {
    var res = (0, _avlTreeReservoir2.default)(10, 60000);
    for (let i = 0; i < 3000; i++) {
      let item = Math.random();
      res.pushSome(item);
      clock.tick(100);
    }
    _sinon2.default.assert.match(res.size(), 10);
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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